#!/usr/bin/env perl
use strict;
use warnings;
use Audio::SID;
use Data::Dumper;
use Cwd qw(getcwd);

opendir my $dh, getcwd;
my @files = readdir $dh;

foreach my $file (@files) {
    next if $file =~ /^\.\.?$/;
    next if $file !~ /^.*\.sid$/;
    print "Processing " . $file .  "\n";
    my $mySID = new Audio::SID('-filename' => $file);
    $mySID->set(author => '?', title => '?', released => '?');
    $mySID->validate();
    $mySID->write('-filename' => $file);
}
